package com.agilex.healthcare.veteranappointment.clientapi;

import java.net.URI;
import java.net.URISyntaxException;

public class JerseyClientHandle {
	private URI baseResourceUri = null;
	private boolean cacheJerseyClient = false;
	private javax.ws.rs.client.Client cachedJerseyClient = null;
	private boolean cacheJerseyWebResource = false;
	private javax.ws.rs.client.WebTarget cachedJerseyWebTarget = null;

	public javax.ws.rs.client.Client getJerseyClient() {
		javax.ws.rs.client.Client jerseyclient = null;

		if (isCacheJerseyClientEnabled()) {
			jerseyclient = cachedJerseyClient;
		}
		if (jerseyclient == null) {
			jerseyclient = JerseyFactory.createJerseyClient();
			if (isCacheJerseyClientEnabled()) {
				cachedJerseyClient = jerseyclient;
			}
		}
		return jerseyclient;
	}

	public javax.ws.rs.client.WebTarget resource() {
		javax.ws.rs.client.WebTarget jerseyWebTarget = null;
		if (isCacheJerseyWebResourceEnabled()) {
			jerseyWebTarget = cachedJerseyWebTarget;
		}
		if (jerseyWebTarget == null) {
			jerseyWebTarget = getJerseyClient().target(this.baseResourceUri);
			if (isCacheJerseyWebResourceEnabled()) {
				cachedJerseyWebTarget = jerseyWebTarget;
			}
		}
		return jerseyWebTarget;
	}

	public javax.ws.rs.client.WebTarget resource(String uri) {
		URI uriobject = null;
		try {
			uriobject = new URI(uri);
		} catch (URISyntaxException ex) {
			throw new RuntimeException("Unable to parse URI " + uri, ex);
		}
		return resource(uriobject);
	}

	public javax.ws.rs.client.WebTarget resource(URI uri) {
		javax.ws.rs.client.Client client = getJerseyClient();
		return client.target(uri);
	}

	/**
	 * @return the cacheJerseyClient
	 */
	public boolean isCacheJerseyClientEnabled() {
		return cacheJerseyClient;
	}

	/**
	 * @param enabled
	 *            /disable caching of the jersey client
	 */
	public void setCacheJerseyClientEnabled(boolean enabled) {
		this.cacheJerseyClient = enabled;
	}

	/**
	 * @return the cacheJerseyWebResource
	 */
	public boolean isCacheJerseyWebResourceEnabled() {
		return cacheJerseyWebResource;
	}

	/**
	 * @param enabled
	 *            the cacheJerseyWebResource to set
	 */
	public void setCacheJerseyWebResourceEnabled(boolean enabled) {
		this.cacheJerseyWebResource = enabled;
	}

}
